/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal;

import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.KParameterImpl;
import kotlin.reflect.jvm.internal.ReflectionObjectRenderer$WhenMappings;
import kotlin.reflect.jvm.internal.ReflectionObjectRenderer$renderFunction$1$1;
import kotlin.reflect.jvm.internal.ReflectionObjectRenderer$renderLambda$1$1;
import kotlin.reflect.jvm.internal.UtilKt;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ReceiverParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRenderer;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;

public final class ReflectionObjectRenderer {
    public static final ReflectionObjectRenderer INSTANCE = new ReflectionObjectRenderer();
    private static final DescriptorRenderer renderer = DescriptorRenderer.FQ_NAMES_IN_TYPES;

    private ReflectionObjectRenderer() {
    }

    private final void appendReceiverType(StringBuilder stringBuilder, ReceiverParameterDescriptor receiverParameterDescriptor) {
        if (receiverParameterDescriptor != null) {
            StringBuilder stringBuilder2 = stringBuilder;
            KotlinType kotlinType = receiverParameterDescriptor.getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType, "receiver.type");
            stringBuilder2.append(this.renderType(kotlinType));
            stringBuilder2.append(".");
        }
    }

    private final void appendReceivers(StringBuilder stringBuilder, CallableDescriptor callableDescriptor) {
        ReceiverParameterDescriptor receiverParameterDescriptor = UtilKt.getInstanceReceiverParameter(callableDescriptor);
        callableDescriptor = callableDescriptor.getExtensionReceiverParameter();
        this.appendReceiverType(stringBuilder, receiverParameterDescriptor);
        boolean bl = receiverParameterDescriptor != null && callableDescriptor != null;
        if (bl) {
            stringBuilder.append("(");
        }
        this.appendReceiverType(stringBuilder, (ReceiverParameterDescriptor)callableDescriptor);
        if (bl) {
            stringBuilder.append(")");
        }
    }

    private final String renderCallable(CallableDescriptor callableDescriptor) {
        block4: {
            String string;
            block3: {
                block2: {
                    if (!(callableDescriptor instanceof PropertyDescriptor)) break block2;
                    string = this.renderProperty((PropertyDescriptor)callableDescriptor);
                    break block3;
                }
                if (!(callableDescriptor instanceof FunctionDescriptor)) break block4;
                string = this.renderFunction((FunctionDescriptor)callableDescriptor);
            }
            return string;
        }
        throw new IllegalStateException(("Illegal callable: " + callableDescriptor).toString());
    }

    public final String renderProperty(PropertyDescriptor propertyDescriptor) {
        StringBuilder stringBuilder;
        PropertyDescriptor propertyDescriptor2 = propertyDescriptor;
        Intrinsics.checkNotNullParameter(propertyDescriptor2, "descriptor");
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        Object object = propertyDescriptor2.isVar() ? "var " : "val ";
        Object object2 = stringBuilder2;
        ((StringBuilder)object2).append((String)object);
        object = INSTANCE;
        StringBuilder stringBuilder3 = stringBuilder2;
        super.appendReceivers(stringBuilder2, propertyDescriptor);
        Name name = propertyDescriptor.getName();
        Intrinsics.checkNotNullExpressionValue(name, "descriptor.name");
        stringBuilder3.append(renderer.renderName(name, true));
        stringBuilder3.append(": ");
        KotlinType kotlinType = propertyDescriptor.getType();
        Intrinsics.checkNotNullExpressionValue(kotlinType, "descriptor.type");
        ((StringBuilder)object2).append(((ReflectionObjectRenderer)object).renderType(kotlinType));
        String string = ((StringBuilder)object2).toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    public final String renderFunction(FunctionDescriptor functionDescriptor) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(functionDescriptor, "descriptor");
        Object object = stringBuilder;
        stringBuilder = new StringBuilder();
        stringBuilder.append("fun ");
        ReflectionObjectRenderer reflectionObjectRenderer = INSTANCE;
        Object object2 = object;
        reflectionObjectRenderer.appendReceivers((StringBuilder)object, functionDescriptor);
        Name name = functionDescriptor.getName();
        Intrinsics.checkNotNullExpressionValue(name, "descriptor.name");
        ((StringBuilder)object).append(renderer.renderName(name, true));
        List list = functionDescriptor.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list, "descriptor.valueParameters");
        object = ReflectionObjectRenderer$renderFunction$1$1.INSTANCE;
        CollectionsKt.joinTo$default(list, (Appendable)object, ", ", "(", ")", 0, null, (Function1)object, 48, null);
        ((StringBuilder)object2).append(": ");
        KotlinType kotlinType = functionDescriptor.getReturnType();
        Intrinsics.checkNotNull(kotlinType);
        stringBuilder.append(reflectionObjectRenderer.renderType(kotlinType));
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    public final String renderLambda(FunctionDescriptor functionDescriptor) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(functionDescriptor, "invoke");
        Object object = stringBuilder;
        stringBuilder = new StringBuilder();
        ReflectionObjectRenderer reflectionObjectRenderer = INSTANCE;
        Object object2 = object;
        reflectionObjectRenderer.appendReceivers((StringBuilder)object, functionDescriptor);
        List list = functionDescriptor.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list, "invoke.valueParameters");
        object = ReflectionObjectRenderer$renderLambda$1$1.INSTANCE;
        CollectionsKt.joinTo$default(list, (Appendable)object, ", ", "(", ")", 0, null, (Function1)object, 48, null);
        ((StringBuilder)object2).append(" -> ");
        KotlinType kotlinType = functionDescriptor.getReturnType();
        Intrinsics.checkNotNull(kotlinType);
        stringBuilder.append(reflectionObjectRenderer.renderType(kotlinType));
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    public final String renderParameter(KParameterImpl kParameterImpl) {
        StringBuilder stringBuilder;
        KParameterImpl kParameterImpl2 = kParameterImpl;
        Intrinsics.checkNotNullParameter(kParameterImpl2, "parameter");
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        int n = ReflectionObjectRenderer$WhenMappings.$EnumSwitchMapping$0[kParameterImpl2.getKind().ordinal()];
        if (n != 1) {
            if (n != 2) {
                if (n == 3) {
                    stringBuilder2.append("parameter #" + kParameterImpl.getIndex() + ' ' + kParameterImpl.getName());
                }
            } else {
                stringBuilder2.append("instance parameter");
            }
        } else {
            stringBuilder2.append("extension receiver parameter");
        }
        Object object = stringBuilder2;
        ((StringBuilder)object).append(" of ");
        ((StringBuilder)object).append(INSTANCE.renderCallable(kParameterImpl.getCallable().getDescriptor()));
        String string = ((StringBuilder)object).toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    public final String renderType(KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter(kotlinType, "type");
        return renderer.renderType(kotlinType);
    }
}

