/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors;

import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptorVisitor;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.storage.StorageManager;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.Variance;

final class CapturedTypeParameterDescriptor
implements TypeParameterDescriptor {
    private final TypeParameterDescriptor originalDescriptor;
    private final DeclarationDescriptor declarationDescriptor;
    private final int declaredTypeParametersCount;

    public CapturedTypeParameterDescriptor(TypeParameterDescriptor typeParameterDescriptor, DeclarationDescriptor declarationDescriptor, int n) {
        Intrinsics.checkNotNullParameter(typeParameterDescriptor, "originalDescriptor");
        Intrinsics.checkNotNullParameter(declarationDescriptor, "declarationDescriptor");
        this.originalDescriptor = typeParameterDescriptor;
        this.declarationDescriptor = declarationDescriptor;
        this.declaredTypeParametersCount = n;
    }

    @Override
    public Annotations getAnnotations() {
        return this.originalDescriptor.getAnnotations();
    }

    @Override
    public Object accept(DeclarationDescriptorVisitor declarationDescriptorVisitor, Object object) {
        return this.originalDescriptor.accept(declarationDescriptorVisitor, object);
    }

    @Override
    public SimpleType getDefaultType() {
        return this.originalDescriptor.getDefaultType();
    }

    @Override
    public Name getName() {
        return this.originalDescriptor.getName();
    }

    @Override
    public SourceElement getSource() {
        return this.originalDescriptor.getSource();
    }

    @Override
    public StorageManager getStorageManager() {
        return this.originalDescriptor.getStorageManager();
    }

    @Override
    public TypeConstructor getTypeConstructor() {
        return this.originalDescriptor.getTypeConstructor();
    }

    @Override
    public List getUpperBounds() {
        return this.originalDescriptor.getUpperBounds();
    }

    @Override
    public Variance getVariance() {
        return this.originalDescriptor.getVariance();
    }

    @Override
    public boolean isReified() {
        return this.originalDescriptor.isReified();
    }

    @Override
    public boolean isCapturedFromOuterDeclaration() {
        return true;
    }

    @Override
    public TypeParameterDescriptor getOriginal() {
        TypeParameterDescriptor typeParameterDescriptor = this.originalDescriptor.getOriginal();
        Intrinsics.checkNotNullExpressionValue(typeParameterDescriptor, "originalDescriptor.original");
        return typeParameterDescriptor;
    }

    @Override
    public DeclarationDescriptor getContainingDeclaration() {
        return this.declarationDescriptor;
    }

    @Override
    public int getIndex() {
        return this.declaredTypeParametersCount + this.originalDescriptor.getIndex();
    }

    public String toString() {
        return this.originalDescriptor + "[inner-copy]";
    }
}

