/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java.descriptors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.ValueParameterDescriptorImpl;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors.LazyJavaStaticClassScope;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;

public abstract class UtilKt {
    public static final List copyValueParameters(Collection object, Collection collection, CallableDescriptor callableDescriptor) {
        ArrayList arrayList;
        Intrinsics.checkNotNullParameter(object, "newValueParameterTypes");
        Intrinsics.checkNotNullParameter(collection, "oldValueParameters");
        Intrinsics.checkNotNullParameter(callableDescriptor, "newOwner");
        boolean bl = object.size() == collection.size();
        if (_Assertions.ENABLED && !bl) {
            object = "Different value parameters sizes: Enhanced = " + object.size() + ", Old = " + collection.size();
            throw new AssertionError(object);
        }
        object = CollectionsKt.zip((Iterable)object, collection);
        collection = arrayList;
        arrayList = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object, 10));
        object = object.iterator();
        while (object.hasNext()) {
            Pair pair = (Pair)object.next();
            KotlinType kotlinType = (KotlinType)pair.component1();
            Object object2 = (ValueParameterDescriptor)pair.component2();
            ValueParameterDescriptor valueParameterDescriptor = null;
            int n = object2.getIndex();
            Annotations annotations2 = object2.getAnnotations();
            Name name = object2.getName();
            Intrinsics.checkNotNullExpressionValue(name, "oldParameter.name");
            boolean bl2 = object2.declaresDefaultValue();
            boolean bl3 = object2.isCrossinline();
            boolean bl4 = object2.isNoinline();
            KotlinType kotlinType2 = object2.getVarargElementType() != null ? DescriptorUtilsKt.getModule(callableDescriptor).getBuiltIns().getArrayElementType(kotlinType) : null;
            object2 = object2.getSource();
            Intrinsics.checkNotNullExpressionValue(object2, "oldParameter.source");
            ValueParameterDescriptorImpl valueParameterDescriptorImpl = new ValueParameterDescriptorImpl(callableDescriptor, valueParameterDescriptor, n, annotations2, name, kotlinType, bl2, bl3, bl4, kotlinType2, (SourceElement)object2);
            collection.add(valueParameterDescriptorImpl);
        }
        return collection;
    }

    public static final LazyJavaStaticClassScope getParentJavaStaticClassScope(ClassDescriptor classDescriptor) {
        ClassDescriptor classDescriptor2 = classDescriptor;
        Intrinsics.checkNotNullParameter(classDescriptor2, "<this>");
        classDescriptor = DescriptorUtilsKt.getSuperClassNotAny(classDescriptor2);
        if (classDescriptor == null) {
            return null;
        }
        MemberScope memberScope2 = classDescriptor.getStaticScope();
        memberScope2 = memberScope2 instanceof LazyJavaStaticClassScope ? (LazyJavaStaticClassScope)memberScope2 : null;
        if (memberScope2 == null) {
            memberScope2 = UtilKt.getParentJavaStaticClassScope(classDescriptor);
        }
        return memberScope2;
    }
}

