/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.protobuf;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import kotlin.reflect.jvm.internal.impl.protobuf.SmallSortedMap$1;
import kotlin.reflect.jvm.internal.impl.protobuf.SmallSortedMap$EmptySet;
import kotlin.reflect.jvm.internal.impl.protobuf.SmallSortedMap$Entry;
import kotlin.reflect.jvm.internal.impl.protobuf.SmallSortedMap$EntrySet;

abstract class SmallSortedMap
extends AbstractMap {
    private final int maxArraySize;
    private List entryList;
    private Map overflowEntries;
    private boolean isImmutable;
    private volatile SmallSortedMap$EntrySet lazyEntrySet;

    static SmallSortedMap newFieldMap(int n) {
        return new SmallSortedMap$1(n);
    }

    private SmallSortedMap(int n) {
        SmallSortedMap smallSortedMap = this;
        smallSortedMap.maxArraySize = n;
        smallSortedMap.entryList = Collections.emptyList();
        smallSortedMap.overflowEntries = Collections.emptyMap();
    }

    private Object removeArrayEntryAt(int n) {
        SmallSortedMap smallSortedMap = this;
        smallSortedMap.checkMutable();
        Object object = ((SmallSortedMap$Entry)smallSortedMap.entryList.remove(n)).getValue();
        if (!smallSortedMap.overflowEntries.isEmpty()) {
            Iterator iterator2 = this.getOverflowEntriesMutable().entrySet().iterator();
            this.entryList.add(new SmallSortedMap$Entry(this, iterator2.next()));
            iterator2.remove();
        }
        return object;
    }

    private int binarySearchInArray(Comparable comparable) {
        int n;
        int n2 = 0;
        int n3 = this.entryList.size() - 1;
        if (n3 >= 0) {
            n = comparable.compareTo(((SmallSortedMap$Entry)this.entryList.get(n3)).getKey());
            if (n > 0) {
                return -(n3 + 2);
            }
            if (n == 0) {
                return n3;
            }
        }
        while (n2 <= n3) {
            n = (n2 + n3) / 2;
            int n4 = comparable.compareTo(((SmallSortedMap$Entry)this.entryList.get(n)).getKey());
            if (n4 < 0) {
                n3 = n - 1;
                continue;
            }
            if (n4 > 0) {
                n2 = n + 1;
                continue;
            }
            return n;
        }
        return -(n2 + 1);
    }

    private void checkMutable() {
        if (!this.isImmutable) {
            return;
        }
        throw new UnsupportedOperationException();
    }

    private SortedMap getOverflowEntriesMutable() {
        SmallSortedMap smallSortedMap = this;
        smallSortedMap.checkMutable();
        if (smallSortedMap.overflowEntries.isEmpty() && !(this.overflowEntries instanceof TreeMap)) {
            TreeMap treeMap;
            TreeMap treeMap2 = treeMap;
            treeMap = new TreeMap();
            this.overflowEntries = treeMap2;
        }
        return (SortedMap)this.overflowEntries;
    }

    private void ensureEntryArrayMutable() {
        SmallSortedMap smallSortedMap = this;
        smallSortedMap.checkMutable();
        if (smallSortedMap.entryList.isEmpty() && !(this.entryList instanceof ArrayList)) {
            this.entryList = new ArrayList(this.maxArraySize);
        }
    }

    /* synthetic */ SmallSortedMap(int n, SmallSortedMap$1 smallSortedMap$1) {
        this(n);
    }

    static /* synthetic */ void access$200(SmallSortedMap smallSortedMap) {
        smallSortedMap.checkMutable();
    }

    static /* synthetic */ List access$400(SmallSortedMap smallSortedMap) {
        return smallSortedMap.entryList;
    }

    static /* synthetic */ Object access$500(SmallSortedMap smallSortedMap, int n) {
        return smallSortedMap.removeArrayEntryAt(n);
    }

    static /* synthetic */ Map access$600(SmallSortedMap smallSortedMap) {
        return smallSortedMap.overflowEntries;
    }

    public void makeImmutable() {
        if (!this.isImmutable) {
            Map map = this.overflowEntries.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(this.overflowEntries);
            SmallSortedMap smallSortedMap = this;
            smallSortedMap.overflowEntries = map;
            smallSortedMap.isImmutable = true;
        }
    }

    public boolean isImmutable() {
        return this.isImmutable;
    }

    public int getNumArrayEntries() {
        return this.entryList.size();
    }

    public Map.Entry getArrayEntryAt(int n) {
        return (Map.Entry)this.entryList.get(n);
    }

    public Iterable getOverflowEntries() {
        return this.overflowEntries.isEmpty() ? SmallSortedMap$EmptySet.iterable() : this.overflowEntries.entrySet();
    }

    @Override
    public int size() {
        return this.entryList.size() + this.overflowEntries.size();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.binarySearchInArray((Comparable)(object = (Comparable)object)) >= 0 || this.overflowEntries.containsKey(object);
    }

    @Override
    public Object get(Object object) {
        int n = this.binarySearchInArray((Comparable)(object = (Comparable)object));
        if (n >= 0) {
            return ((SmallSortedMap$Entry)this.entryList.get(n)).getValue();
        }
        return this.overflowEntries.get(object);
    }

    @Override
    public Object put(Comparable comparable, Object object) {
        SmallSortedMap$Entry smallSortedMap$Entry;
        SmallSortedMap smallSortedMap = this;
        smallSortedMap.checkMutable();
        int n = smallSortedMap.binarySearchInArray(comparable);
        if (n >= 0) {
            return ((SmallSortedMap$Entry)this.entryList.get(n)).setValue(object);
        }
        this.ensureEntryArrayMutable();
        n = -(n + 1);
        if (n >= this.maxArraySize) {
            return this.getOverflowEntriesMutable().put(comparable, object);
        }
        int n2 = this.maxArraySize;
        if (this.entryList.size() == n2) {
            Comparable comparable2;
            SmallSortedMap smallSortedMap2 = this;
            SmallSortedMap$Entry smallSortedMap$Entry2 = comparable2 = (SmallSortedMap$Entry)smallSortedMap2.entryList.remove(n2 - 1);
            comparable2 = smallSortedMap$Entry2.getKey();
            smallSortedMap2.getOverflowEntriesMutable().put(comparable2, smallSortedMap$Entry2.getValue());
        }
        SmallSortedMap$Entry smallSortedMap$Entry3 = smallSortedMap$Entry;
        smallSortedMap$Entry = new SmallSortedMap$Entry(this, comparable, object);
        this.entryList.add(n, smallSortedMap$Entry3);
        return null;
    }

    @Override
    public void clear() {
        SmallSortedMap smallSortedMap = this;
        smallSortedMap.checkMutable();
        if (!smallSortedMap.entryList.isEmpty()) {
            this.entryList.clear();
        }
        if (!this.overflowEntries.isEmpty()) {
            this.overflowEntries.clear();
        }
    }

    @Override
    public Object remove(Object object) {
        this.checkMutable();
        object = (Comparable)object;
        int n = this.binarySearchInArray((Comparable)object);
        if (n >= 0) {
            return this.removeArrayEntryAt(n);
        }
        if (this.overflowEntries.isEmpty()) {
            return null;
        }
        return this.overflowEntries.remove(object);
    }

    @Override
    public Set entrySet() {
        if (this.lazyEntrySet == null) {
            SmallSortedMap$EntrySet smallSortedMap$EntrySet;
            SmallSortedMap$EntrySet smallSortedMap$EntrySet2 = smallSortedMap$EntrySet;
            smallSortedMap$EntrySet = new SmallSortedMap$EntrySet(this, null);
            this.lazyEntrySet = smallSortedMap$EntrySet2;
        }
        return this.lazyEntrySet;
    }
}

