/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.jvm;

import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.incremental.components.NoLookupLocation;
import kotlin.reflect.jvm.internal.impl.load.java.components.JavaResolverCache;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.LazyJavaPackageFragmentProvider;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors.LazyJavaPackageFragment;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaClass;
import kotlin.reflect.jvm.internal.impl.load.java.structure.LightClassOriginKind;
import kotlin.reflect.jvm.internal.impl.name.FqName;

public final class JavaDescriptorResolver {
    private final LazyJavaPackageFragmentProvider packageFragmentProvider;
    private final JavaResolverCache javaResolverCache;

    public JavaDescriptorResolver(LazyJavaPackageFragmentProvider lazyJavaPackageFragmentProvider, JavaResolverCache javaResolverCache) {
        Intrinsics.checkNotNullParameter(lazyJavaPackageFragmentProvider, "packageFragmentProvider");
        Intrinsics.checkNotNullParameter(javaResolverCache, "javaResolverCache");
        this.packageFragmentProvider = lazyJavaPackageFragmentProvider;
        this.javaResolverCache = javaResolverCache;
    }

    public final LazyJavaPackageFragmentProvider getPackageFragmentProvider() {
        return this.packageFragmentProvider;
    }

    public final ClassDescriptor resolveClass(JavaClass javaClass) {
        Object object;
        JavaClass javaClass2 = javaClass;
        Intrinsics.checkNotNullParameter(javaClass2, "javaClass");
        FqName fqName2 = javaClass2.getFqName();
        if (fqName2 != null && javaClass.getLightClassOriginKind() == LightClassOriginKind.SOURCE) {
            return ((JavaDescriptorResolver)object).javaResolverCache.getClassResolvedFromSource(fqName2);
        }
        JavaClass javaClass3 = javaClass.getOuterClass();
        if (javaClass3 != null) {
            object = (object = ((JavaDescriptorResolver)object).resolveClass(javaClass3)) != null ? object.getUnsubstitutedInnerClassesScope() : null;
            object = object != null ? object.getContributedClassifier(javaClass.getName(), NoLookupLocation.FROM_JAVA_LOADER) : null;
            return object instanceof ClassDescriptor ? (ClassDescriptor)object : null;
        }
        if (fqName2 == null) {
            return null;
        }
        FqName fqName3 = fqName2.parent();
        Intrinsics.checkNotNullExpressionValue(fqName3, "fqName.parent()");
        object = (LazyJavaPackageFragment)CollectionsKt.firstOrNull(((JavaDescriptorResolver)object).packageFragmentProvider.getPackageFragments(fqName3));
        return object != null ? ((LazyJavaPackageFragment)object).findClassifierByJavaClass$descriptors_jvm(javaClass) : null;
    }
}

