/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import java.util.ArrayList;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.NotFoundClasses;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf$Annotation;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf$Annotation$Argument$Value;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf$Constructor;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf$EnumEntry;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf$Function;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf$Property;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf$Type;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf$TypeParameter;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf$ValueParameter;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.ProtoBufUtilKt;
import kotlin.reflect.jvm.internal.impl.protobuf.GeneratedMessageLite$ExtendableMessage;
import kotlin.reflect.jvm.internal.impl.protobuf.MessageLite;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.serialization.SerializerExtensionProtocol;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.AnnotatedCallableKind;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.AnnotationAndConstantLoader;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.AnnotationAndConstantLoaderImpl$WhenMappings;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.AnnotationDeserializer;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ProtoContainer;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ProtoContainer$Class;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;

public final class AnnotationAndConstantLoaderImpl
implements AnnotationAndConstantLoader {
    private final SerializerExtensionProtocol protocol;
    private final AnnotationDeserializer deserializer;

    public AnnotationAndConstantLoaderImpl(ModuleDescriptor moduleDescriptor, NotFoundClasses notFoundClasses, SerializerExtensionProtocol serializerExtensionProtocol) {
        AnnotationDeserializer annotationDeserializer;
        Intrinsics.checkNotNullParameter(moduleDescriptor, "module");
        Intrinsics.checkNotNullParameter(notFoundClasses, "notFoundClasses");
        Intrinsics.checkNotNullParameter(serializerExtensionProtocol, "protocol");
        ((AnnotationAndConstantLoaderImpl)((Object)annotationDeserializer2)).protocol = serializerExtensionProtocol;
        AnnotationDeserializer annotationDeserializer2 = annotationDeserializer;
        annotationDeserializer = new AnnotationDeserializer(moduleDescriptor, notFoundClasses);
        v1.deserializer = annotationDeserializer2;
    }

    @Override
    public List loadClassAnnotations(ProtoContainer$Class protoContainer$Class) {
        ArrayList<AnnotationDescriptor> arrayList;
        ProtoContainer$Class protoContainer$Class2 = protoContainer$Class;
        Intrinsics.checkNotNullParameter(protoContainer$Class2, "container");
        Object object = (List)protoContainer$Class2.getClassProto().getExtension(this.protocol.getClassAnnotation());
        if (object == null) {
            object = CollectionsKt.emptyList();
        }
        ArrayList<AnnotationDescriptor> arrayList2 = arrayList;
        arrayList = new ArrayList<AnnotationDescriptor>(CollectionsKt.collectionSizeOrDefault((Iterable)object, 10));
        object = object.iterator();
        while (object.hasNext()) {
            ProtoBuf$Annotation protoBuf$Annotation = (ProtoBuf$Annotation)object.next();
            arrayList2.add(this.deserializer.deserializeAnnotation(protoBuf$Annotation, protoContainer$Class.getNameResolver()));
        }
        return arrayList2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List loadCallableAnnotations(ProtoContainer protoContainer, MessageLite object, AnnotatedCallableKind object2) {
        ArrayList arrayList;
        Intrinsics.checkNotNullParameter(protoContainer, "container");
        Intrinsics.checkNotNullParameter(object, "proto");
        Intrinsics.checkNotNullParameter(object2, "kind");
        if (object instanceof ProtoBuf$Constructor) {
            object = (List)((ProtoBuf$Constructor)object).getExtension(this.protocol.getConstructorAnnotation());
        } else if (object instanceof ProtoBuf$Function) {
            object = (List)((ProtoBuf$Function)object).getExtension(this.protocol.getFunctionAnnotation());
        } else {
            if (!(object instanceof ProtoBuf$Property)) throw new IllegalStateException(("Unknown message: " + object).toString());
            int n = AnnotationAndConstantLoaderImpl$WhenMappings.$EnumSwitchMapping$0[((Enum)object2).ordinal()];
            if (n != 1) {
                if (n != 2) {
                    if (n != 3) throw new IllegalStateException("Unsupported callable kind with property proto".toString());
                    object = (List)((ProtoBuf$Property)object).getExtension(this.protocol.getPropertySetterAnnotation());
                } else {
                    object = (List)((ProtoBuf$Property)object).getExtension(this.protocol.getPropertyGetterAnnotation());
                }
            } else {
                object = (List)((ProtoBuf$Property)object).getExtension(this.protocol.getPropertyAnnotation());
            }
        }
        if (object == null) {
            object = CollectionsKt.emptyList();
        }
        object2 = arrayList;
        arrayList = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object, 10));
        object = object.iterator();
        while (object.hasNext()) {
            ProtoBuf$Annotation protoBuf$Annotation = (ProtoBuf$Annotation)object.next();
            object2.add(this.deserializer.deserializeAnnotation(protoBuf$Annotation, protoContainer.getNameResolver()));
        }
        return object2;
    }

    @Override
    public List loadPropertyBackingFieldAnnotations(ProtoContainer protoContainer, ProtoBuf$Property protoBuf$Property) {
        Intrinsics.checkNotNullParameter(protoContainer, "container");
        Intrinsics.checkNotNullParameter(protoBuf$Property, "proto");
        return CollectionsKt.emptyList();
    }

    @Override
    public List loadPropertyDelegateFieldAnnotations(ProtoContainer protoContainer, ProtoBuf$Property protoBuf$Property) {
        Intrinsics.checkNotNullParameter(protoContainer, "container");
        Intrinsics.checkNotNullParameter(protoBuf$Property, "proto");
        return CollectionsKt.emptyList();
    }

    @Override
    public List loadEnumEntryAnnotations(ProtoContainer protoContainer, ProtoBuf$EnumEntry iterator2) {
        ArrayList<AnnotationDescriptor> arrayList;
        Intrinsics.checkNotNullParameter(protoContainer, "container");
        Intrinsics.checkNotNullParameter(iterator2, "proto");
        iterator2 = (List)((GeneratedMessageLite$ExtendableMessage)((Object)iterator2)).getExtension(this.protocol.getEnumEntryAnnotation());
        if (iterator2 == null) {
            iterator2 = CollectionsKt.emptyList();
        }
        ArrayList<AnnotationDescriptor> arrayList2 = arrayList;
        arrayList = new ArrayList<AnnotationDescriptor>(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)iterator2), 10));
        iterator2 = iterator2.iterator();
        while (iterator2.hasNext()) {
            ProtoBuf$Annotation protoBuf$Annotation = (ProtoBuf$Annotation)iterator2.next();
            arrayList2.add(this.deserializer.deserializeAnnotation(protoBuf$Annotation, protoContainer.getNameResolver()));
        }
        return arrayList2;
    }

    @Override
    public List loadValueParameterAnnotations(ProtoContainer protoContainer, MessageLite iterator2, AnnotatedCallableKind object, int n, ProtoBuf$ValueParameter protoBuf$ValueParameter) {
        ArrayList arrayList;
        Intrinsics.checkNotNullParameter(protoContainer, "container");
        Intrinsics.checkNotNullParameter(iterator2, "callableProto");
        Intrinsics.checkNotNullParameter(object, "kind");
        Intrinsics.checkNotNullParameter(protoBuf$ValueParameter, "proto");
        iterator2 = (List)protoBuf$ValueParameter.getExtension(this.protocol.getParameterAnnotation());
        if (iterator2 == null) {
            iterator2 = CollectionsKt.emptyList();
        }
        object = arrayList;
        arrayList = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)iterator2), 10));
        iterator2 = iterator2.iterator();
        while (iterator2.hasNext()) {
            ProtoBuf$Annotation protoBuf$Annotation = (ProtoBuf$Annotation)iterator2.next();
            object.add(this.deserializer.deserializeAnnotation(protoBuf$Annotation, protoContainer.getNameResolver()));
        }
        return object;
    }

    @Override
    public List loadExtensionReceiverParameterAnnotations(ProtoContainer protoContainer, MessageLite messageLite, AnnotatedCallableKind annotatedCallableKind) {
        Intrinsics.checkNotNullParameter(protoContainer, "container");
        Intrinsics.checkNotNullParameter(messageLite, "proto");
        Intrinsics.checkNotNullParameter((Object)annotatedCallableKind, "kind");
        return CollectionsKt.emptyList();
    }

    @Override
    public List loadTypeAnnotations(ProtoBuf$Type iterator2, NameResolver nameResolver) {
        ArrayList<AnnotationDescriptor> arrayList;
        Intrinsics.checkNotNullParameter(iterator2, "proto");
        Intrinsics.checkNotNullParameter(nameResolver, "nameResolver");
        iterator2 = (List)((GeneratedMessageLite$ExtendableMessage)((Object)iterator2)).getExtension(this.protocol.getTypeAnnotation());
        if (iterator2 == null) {
            iterator2 = CollectionsKt.emptyList();
        }
        ArrayList<AnnotationDescriptor> arrayList2 = arrayList;
        arrayList = new ArrayList<AnnotationDescriptor>(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)iterator2), 10));
        iterator2 = iterator2.iterator();
        while (iterator2.hasNext()) {
            ProtoBuf$Annotation protoBuf$Annotation = (ProtoBuf$Annotation)iterator2.next();
            arrayList2.add(this.deserializer.deserializeAnnotation(protoBuf$Annotation, nameResolver));
        }
        return arrayList2;
    }

    @Override
    public List loadTypeParameterAnnotations(ProtoBuf$TypeParameter iterator2, NameResolver nameResolver) {
        ArrayList<AnnotationDescriptor> arrayList;
        Intrinsics.checkNotNullParameter(iterator2, "proto");
        Intrinsics.checkNotNullParameter(nameResolver, "nameResolver");
        iterator2 = (List)((GeneratedMessageLite$ExtendableMessage)((Object)iterator2)).getExtension(this.protocol.getTypeParameterAnnotation());
        if (iterator2 == null) {
            iterator2 = CollectionsKt.emptyList();
        }
        ArrayList<AnnotationDescriptor> arrayList2 = arrayList;
        arrayList = new ArrayList<AnnotationDescriptor>(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)iterator2), 10));
        iterator2 = iterator2.iterator();
        while (iterator2.hasNext()) {
            ProtoBuf$Annotation protoBuf$Annotation = (ProtoBuf$Annotation)iterator2.next();
            arrayList2.add(this.deserializer.deserializeAnnotation(protoBuf$Annotation, nameResolver));
        }
        return arrayList2;
    }

    @Override
    public ConstantValue loadPropertyConstant(ProtoContainer protoContainer, ProtoBuf$Property generatedMessageLite, KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter(protoContainer, "container");
        Intrinsics.checkNotNullParameter(generatedMessageLite, "proto");
        Intrinsics.checkNotNullParameter(kotlinType, "expectedType");
        generatedMessageLite = (ProtoBuf$Annotation$Argument$Value)ProtoBufUtilKt.getExtensionOrNull(generatedMessageLite, this.protocol.getCompileTimeValue());
        if (generatedMessageLite == null) {
            return null;
        }
        return this.deserializer.resolveValue(kotlinType, (ProtoBuf$Annotation$Argument$Value)generatedMessageLite, protoContainer.getNameResolver());
    }

    @Override
    public ConstantValue loadAnnotationDefaultValue(ProtoContainer protoContainer, ProtoBuf$Property protoBuf$Property, KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter(protoContainer, "container");
        Intrinsics.checkNotNullParameter(protoBuf$Property, "proto");
        Intrinsics.checkNotNullParameter(kotlinType, "expectedType");
        return null;
    }
}

