/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.storage;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.storage.DefaultSimpleLock;

public final class CancellableSimpleLock
extends DefaultSimpleLock {
    private final Runnable checkCancelled;
    private final Function1 interruptedExceptionHandler;

    public CancellableSimpleLock(Lock lock, Runnable runnable2, Function1 function1) {
        Intrinsics.checkNotNullParameter(lock, "lock");
        Intrinsics.checkNotNullParameter(runnable2, "checkCancelled");
        Intrinsics.checkNotNullParameter(function1, "interruptedExceptionHandler");
        super(lock);
        this.checkCancelled = runnable2;
        this.interruptedExceptionHandler = function1;
    }

    public CancellableSimpleLock(Runnable runnable2, Function1 function1) {
        ReentrantLock reentrantLock;
        CancellableSimpleLock cancellableSimpleLock = reentrantLock2;
        Intrinsics.checkNotNullParameter(runnable2, "checkCancelled");
        Intrinsics.checkNotNullParameter(function1, "interruptedExceptionHandler");
        ReentrantLock reentrantLock2 = reentrantLock;
        reentrantLock = new ReentrantLock();
        cancellableSimpleLock((Lock)reentrantLock2, runnable2, function1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void lock() {
        try {
            while (!this.getLock().tryLock(50L, TimeUnit.MILLISECONDS)) {
                this.checkCancelled.run();
            }
            return;
        }
        catch (InterruptedException interruptedException) {
            this.interruptedExceptionHandler.invoke(interruptedException);
        }
    }
}

