/*
 * Decompiled with CFR 0.152.
 */
package kotlin.sequences;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.DropSequence;
import kotlin.sequences.DropTakeSequence;
import kotlin.sequences.FilteringSequence;
import kotlin.sequences.FlatteningSequence;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.sequences.SequencesKt__SequencesKt;
import kotlin.sequences.SequencesKt___SequencesJvmKt;
import kotlin.sequences.SequencesKt___SequencesKt$asIterable$$inlined$Iterable$1;
import kotlin.sequences.SequencesKt___SequencesKt$filterNotNull$1;
import kotlin.sequences.SequencesKt___SequencesKt$flatMap$2;
import kotlin.sequences.TakeWhileSequence;
import kotlin.sequences.TransformingSequence;
import kotlin.text.StringsKt;

abstract class SequencesKt___SequencesKt
extends SequencesKt___SequencesJvmKt {
    public static Object firstOrNull(Sequence object) {
        Sequence sequence = object;
        Intrinsics.checkNotNullParameter(sequence, "<this>");
        object = sequence.iterator();
        if (!object.hasNext()) {
            return null;
        }
        return object.next();
    }

    public static Object last(Sequence object) {
        Sequence sequence = object;
        Intrinsics.checkNotNullParameter(sequence, "<this>");
        object = sequence.iterator();
        if (object.hasNext()) {
            Object e = object.next();
            while (object.hasNext()) {
                e = object.next();
            }
            return e;
        }
        throw new NoSuchElementException("Sequence is empty.");
    }

    public static Sequence drop(Sequence object, int n) {
        Intrinsics.checkNotNullParameter(object, "<this>");
        if (n >= 0) {
            if (n != 0) {
                if (object instanceof DropTakeSequence) {
                    object = ((DropTakeSequence)object).drop(n);
                } else {
                    DropSequence dropSequence;
                    DropSequence dropSequence2 = dropSequence;
                    dropSequence = new DropSequence((Sequence)object, n);
                    object = dropSequence2;
                }
            }
            return object;
        }
        object = "Requested element count " + n + " is less than zero.";
        throw new IllegalArgumentException(object.toString());
    }

    public static Sequence filter(Sequence sequence, Function1 function1) {
        Intrinsics.checkNotNullParameter(sequence, "<this>");
        Intrinsics.checkNotNullParameter(function1, "predicate");
        return new FilteringSequence(sequence, true, function1);
    }

    public static Sequence filterNot(Sequence sequence, Function1 function1) {
        Intrinsics.checkNotNullParameter(sequence, "<this>");
        Intrinsics.checkNotNullParameter(function1, "predicate");
        return new FilteringSequence(sequence, false, function1);
    }

    public static Sequence filterNotNull(Sequence sequence) {
        Sequence sequence2 = sequence;
        Intrinsics.checkNotNullParameter(sequence2, "<this>");
        Sequence sequence3 = SequencesKt.filterNot(sequence2, SequencesKt___SequencesKt$filterNotNull$1.INSTANCE);
        Intrinsics.checkNotNull(sequence3, "null cannot be cast to non-null type kotlin.sequences.Sequence<T of kotlin.sequences.SequencesKt___SequencesKt.filterNotNull>");
        return sequence3;
    }

    public static Sequence takeWhile(Sequence sequence, Function1 function1) {
        Intrinsics.checkNotNullParameter(sequence, "<this>");
        Intrinsics.checkNotNullParameter(function1, "predicate");
        return new TakeWhileSequence(sequence, function1);
    }

    public static final Collection toCollection(Sequence object, Collection collection) {
        Intrinsics.checkNotNullParameter(object, "<this>");
        Intrinsics.checkNotNullParameter(collection, "destination");
        object = object.iterator();
        while (object.hasNext()) {
            collection.add(object.next());
        }
        return collection;
    }

    public static List toList(Sequence sequence) {
        Sequence sequence2 = sequence;
        Intrinsics.checkNotNullParameter(sequence2, "<this>");
        return CollectionsKt.optimizeReadOnlyList(SequencesKt.toMutableList(sequence2));
    }

    public static List toMutableList(Sequence sequence) {
        Sequence sequence2 = sequence;
        Intrinsics.checkNotNullParameter(sequence2, "<this>");
        return (List)SequencesKt___SequencesKt.toCollection(sequence2, new ArrayList());
    }

    public static Sequence flatMap(Sequence sequence, Function1 function1) {
        Intrinsics.checkNotNullParameter(sequence, "<this>");
        Intrinsics.checkNotNullParameter(function1, "transform");
        SequencesKt___SequencesKt$flatMap$2 sequencesKt___SequencesKt$flatMap$2 = SequencesKt___SequencesKt$flatMap$2.INSTANCE;
        return new FlatteningSequence(sequence, function1, sequencesKt___SequencesKt$flatMap$2);
    }

    public static Sequence map(Sequence sequence, Function1 function1) {
        Intrinsics.checkNotNullParameter(sequence, "<this>");
        Intrinsics.checkNotNullParameter(function1, "transform");
        return new TransformingSequence(sequence, function1);
    }

    public static Sequence mapNotNull(Sequence sequence, Function1 function1) {
        Intrinsics.checkNotNullParameter(sequence, "<this>");
        Intrinsics.checkNotNullParameter(function1, "transform");
        return SequencesKt.filterNotNull(new TransformingSequence(sequence, function1));
    }

    public static int count(Sequence sequence) {
        Sequence sequence2 = sequence;
        Intrinsics.checkNotNullParameter(sequence2, "<this>");
        int n = 0;
        Iterator iterator2 = sequence2.iterator();
        while (iterator2.hasNext()) {
            iterator2.next();
            if (++n >= 0) continue;
            CollectionsKt.throwCountOverflow();
        }
        return n;
    }

    public static Sequence plus(Sequence sequence, Object object) {
        Intrinsics.checkNotNullParameter(sequence, "<this>");
        return SequencesKt__SequencesKt.flatten(SequencesKt__SequencesKt.sequenceOf(sequence, SequencesKt__SequencesKt.sequenceOf(object)));
    }

    public static Sequence plus(Sequence sequence, Iterable iterable) {
        Intrinsics.checkNotNullParameter(sequence, "<this>");
        Intrinsics.checkNotNullParameter(iterable, "elements");
        return SequencesKt__SequencesKt.flatten(SequencesKt__SequencesKt.sequenceOf(sequence, CollectionsKt.asSequence(iterable)));
    }

    public static final Appendable joinTo(Sequence sequence, Appendable appendable, CharSequence charSequence, CharSequence object, CharSequence charSequence2, int n, CharSequence charSequence3, Function1 function1) {
        Intrinsics.checkNotNullParameter(sequence, "<this>");
        Intrinsics.checkNotNullParameter(appendable, "buffer");
        Intrinsics.checkNotNullParameter(charSequence, "separator");
        Intrinsics.checkNotNullParameter(object, "prefix");
        Intrinsics.checkNotNullParameter(charSequence2, "postfix");
        Intrinsics.checkNotNullParameter(charSequence3, "truncated");
        appendable.append((CharSequence)object);
        int n2 = 0;
        object = sequence.iterator();
        while (object.hasNext()) {
            Object e = object.next();
            if (++n2 > 1) {
                appendable.append(charSequence);
            }
            if (n >= 0 && n2 > n) break;
            StringsKt.appendElement(appendable, e, function1);
        }
        if (n >= 0 && n2 > n) {
            appendable.append(charSequence3);
        }
        Appendable appendable2 = appendable;
        appendable2.append(charSequence2);
        return appendable2;
    }

    public static final String joinToString(Sequence sequence, CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3, int n, CharSequence charSequence4, Function1 function1) {
        Intrinsics.checkNotNullParameter(sequence, "<this>");
        Intrinsics.checkNotNullParameter(charSequence, "separator");
        Intrinsics.checkNotNullParameter(charSequence2, "prefix");
        Intrinsics.checkNotNullParameter(charSequence3, "postfix");
        Intrinsics.checkNotNullParameter(charSequence4, "truncated");
        String string = ((StringBuilder)SequencesKt___SequencesKt.joinTo(sequence, new StringBuilder(), charSequence, charSequence2, charSequence3, n, charSequence4, function1)).toString();
        Intrinsics.checkNotNullExpressionValue(string, "joinTo(StringBuilder(), \u2026ed, transform).toString()");
        return string;
    }

    public static /* synthetic */ String joinToString$default(Sequence sequence, CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3, int n, CharSequence charSequence4, Function1 function1, int n2, Object object) {
        if ((n2 & 1) != 0) {
            charSequence = ", ";
        }
        if ((n2 & 2) != 0) {
            charSequence2 = "";
        }
        if ((n2 & 4) != 0) {
            charSequence3 = "";
        }
        if ((n2 & 8) != 0) {
            n = -1;
        }
        if ((n2 & 0x10) != 0) {
            charSequence4 = "...";
        }
        if ((n2 & 0x20) != 0) {
            function1 = null;
        }
        return SequencesKt___SequencesKt.joinToString(sequence, charSequence, charSequence2, charSequence3, n, charSequence4, function1);
    }

    public static Iterable asIterable(Sequence sequence) {
        Intrinsics.checkNotNullParameter(sequence, "<this>");
        return new SequencesKt___SequencesKt$asIterable$$inlined$Iterable$1(sequence);
    }
}

