/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.net.Proxy;
import java.net.ProxySelector;
import java.util.Collection;
import java.util.List;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Authenticator;
import okhttp3.Cache;
import okhttp3.Call;
import okhttp3.CertificatePinner;
import okhttp3.ConnectionPool;
import okhttp3.ConnectionSpec;
import okhttp3.CookieJar;
import okhttp3.Dispatcher;
import okhttp3.Dns;
import okhttp3.EventListener$Factory;
import okhttp3.OkHttpClient$Builder;
import okhttp3.OkHttpClient$Companion;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.internal.Util;
import okhttp3.internal.connection.RealCall;
import okhttp3.internal.connection.RouteDatabase;
import okhttp3.internal.platform.Platform;
import okhttp3.internal.platform.Platform$Companion;
import okhttp3.internal.proxy.NullProxySelector;
import okhttp3.internal.tls.CertificateChainCleaner;

public class OkHttpClient
implements Cloneable {
    public static final OkHttpClient$Companion Companion = new OkHttpClient$Companion(null);
    private static final List DEFAULT_PROTOCOLS = Util.immutableListOf((Object[])new Protocol[]{Protocol.HTTP_2, Protocol.HTTP_1_1});
    private static final List DEFAULT_CONNECTION_SPECS = Util.immutableListOf(ConnectionSpec.MODERN_TLS, ConnectionSpec.CLEARTEXT);
    private final Dispatcher dispatcher;
    private final ConnectionPool connectionPool;
    private final List interceptors;
    private final List networkInterceptors;
    private final EventListener$Factory eventListenerFactory;
    private final boolean retryOnConnectionFailure;
    private final Authenticator authenticator;
    private final boolean followRedirects;
    private final boolean followSslRedirects;
    private final CookieJar cookieJar;
    private final Dns dns;
    private final Proxy proxy;
    private final ProxySelector proxySelector;
    private final Authenticator proxyAuthenticator;
    private final SocketFactory socketFactory;
    private final SSLSocketFactory sslSocketFactoryOrNull;
    private final X509TrustManager x509TrustManager;
    private final List connectionSpecs;
    private final List protocols;
    private final HostnameVerifier hostnameVerifier;
    private final CertificatePinner certificatePinner;
    private final CertificateChainCleaner certificateChainCleaner;
    private final int callTimeoutMillis;
    private final int connectTimeoutMillis;
    private final int readTimeoutMillis;
    private final int writeTimeoutMillis;
    private final int pingIntervalMillis;
    private final long minWebSocketMessageToCompress;
    private final RouteDatabase routeDatabase;

    /*
     * Enabled aggressive block sorting
     */
    public OkHttpClient(OkHttpClient$Builder object) {
        boolean bl;
        Object object2;
        Object object3 = object;
        Intrinsics.checkNotNullParameter(object, "builder");
        this.dispatcher = ((OkHttpClient$Builder)object).getDispatcher$okhttp();
        this.connectionPool = ((OkHttpClient$Builder)object).getConnectionPool$okhttp();
        this.interceptors = Util.toImmutableList(((OkHttpClient$Builder)object).getInterceptors$okhttp());
        this.networkInterceptors = Util.toImmutableList(((OkHttpClient$Builder)object).getNetworkInterceptors$okhttp());
        this.eventListenerFactory = ((OkHttpClient$Builder)object).getEventListenerFactory$okhttp();
        this.retryOnConnectionFailure = ((OkHttpClient$Builder)object).getRetryOnConnectionFailure$okhttp();
        this.authenticator = ((OkHttpClient$Builder)object).getAuthenticator$okhttp();
        this.followRedirects = ((OkHttpClient$Builder)object).getFollowRedirects$okhttp();
        this.followSslRedirects = ((OkHttpClient$Builder)object).getFollowSslRedirects$okhttp();
        this.cookieJar = ((OkHttpClient$Builder)object).getCookieJar$okhttp();
        ((OkHttpClient$Builder)object3).getCache$okhttp();
        this.dns = ((OkHttpClient$Builder)object3).getDns$okhttp();
        this.proxy = ((OkHttpClient$Builder)object).getProxy$okhttp();
        if (((OkHttpClient$Builder)object).getProxy$okhttp() != null) {
            object2 = NullProxySelector.INSTANCE;
        } else {
            object2 = ((OkHttpClient$Builder)object).getProxySelector$okhttp();
            if (object2 == null) {
                object2 = ProxySelector.getDefault();
            }
            if (object2 == null) {
                object2 = NullProxySelector.INSTANCE;
            }
        }
        this.proxySelector = object2;
        this.proxyAuthenticator = ((OkHttpClient$Builder)object).getProxyAuthenticator$okhttp();
        this.socketFactory = ((OkHttpClient$Builder)object).getSocketFactory$okhttp();
        object2 = ((OkHttpClient$Builder)object).getConnectionSpecs$okhttp();
        this.connectionSpecs = object2;
        this.protocols = ((OkHttpClient$Builder)object).getProtocols$okhttp();
        this.hostnameVerifier = ((OkHttpClient$Builder)object).getHostnameVerifier$okhttp();
        this.callTimeoutMillis = ((OkHttpClient$Builder)object).getCallTimeout$okhttp();
        this.connectTimeoutMillis = ((OkHttpClient$Builder)object).getConnectTimeout$okhttp();
        this.readTimeoutMillis = ((OkHttpClient$Builder)object).getReadTimeout$okhttp();
        this.writeTimeoutMillis = ((OkHttpClient$Builder)object).getWriteTimeout$okhttp();
        this.pingIntervalMillis = ((OkHttpClient$Builder)object).getPingInterval$okhttp();
        this.minWebSocketMessageToCompress = ((OkHttpClient$Builder)object).getMinWebSocketMessageToCompress$okhttp();
        RouteDatabase routeDatabase = ((OkHttpClient$Builder)object).getRouteDatabase$okhttp();
        if (routeDatabase == null) {
            RouteDatabase routeDatabase2;
            routeDatabase = routeDatabase2;
            routeDatabase2 = new RouteDatabase();
        }
        this.routeDatabase = routeDatabase;
        if (!(object2 instanceof Collection) || !object2.isEmpty()) {
            object2 = object2.iterator();
            while (object2.hasNext()) {
                if (!((ConnectionSpec)object2.next()).isTls()) continue;
                bl = false;
                break;
            }
        } else {
            bl = true;
        }
        if (bl) {
            OkHttpClient okHttpClient = this;
            okHttpClient.sslSocketFactoryOrNull = null;
            okHttpClient.certificateChainCleaner = null;
            okHttpClient.x509TrustManager = null;
            okHttpClient.certificatePinner = CertificatePinner.DEFAULT;
        } else if (((OkHttpClient$Builder)object).getSslSocketFactoryOrNull$okhttp() != null) {
            Object object4 = object;
            Object object5 = object;
            this.sslSocketFactoryOrNull = ((OkHttpClient$Builder)object).getSslSocketFactoryOrNull$okhttp();
            object = ((OkHttpClient$Builder)object).getCertificateChainCleaner$okhttp();
            Intrinsics.checkNotNull(object);
            this.certificateChainCleaner = object;
            X509TrustManager x509TrustManager = ((OkHttpClient$Builder)object5).getX509TrustManagerOrNull$okhttp();
            Intrinsics.checkNotNull(x509TrustManager);
            this.x509TrustManager = x509TrustManager;
            CertificatePinner certificatePinner = ((OkHttpClient$Builder)object4).getCertificatePinner$okhttp();
            Object object6 = object;
            Intrinsics.checkNotNull(object6);
            this.certificatePinner = certificatePinner.withCertificateChainCleaner$okhttp((CertificateChainCleaner)object6);
        } else {
            Object object7 = object;
            OkHttpClient okHttpClient = this;
            object = Platform.Companion;
            object2 = ((Platform$Companion)object).get().platformTrustManager();
            okHttpClient.x509TrustManager = object2;
            Platform platform = ((Platform$Companion)object).get();
            Object object8 = object2;
            Intrinsics.checkNotNull(object8);
            okHttpClient.sslSocketFactoryOrNull = platform.newSslSocketFactory((X509TrustManager)object8);
            Object object9 = object2;
            Intrinsics.checkNotNull(object9);
            object = CertificateChainCleaner.Companion.get((X509TrustManager)object9);
            okHttpClient.certificateChainCleaner = object;
            CertificatePinner certificatePinner = ((OkHttpClient$Builder)object7).getCertificatePinner$okhttp();
            Object object10 = object;
            Intrinsics.checkNotNull(object10);
            this.certificatePinner = certificatePinner.withCertificateChainCleaner$okhttp((CertificateChainCleaner)object10);
        }
        this.verifyClientState();
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void verifyClientState() {
        boolean bl;
        Object object;
        if (!(((OkHttpClient)object).interceptors.contains(null) ^ true)) {
            object = Intrinsics.stringPlus("Null interceptor: ", ((OkHttpClient)object).interceptors());
            throw new IllegalStateException(object.toString());
        }
        if (!(((OkHttpClient)object).networkInterceptors.contains(null) ^ true)) {
            object = Intrinsics.stringPlus("Null network interceptor: ", ((OkHttpClient)object).networkInterceptors());
            throw new IllegalStateException(object.toString());
        }
        Object object2 = ((OkHttpClient)object).connectionSpecs;
        if (!(object2 instanceof Collection) || !object2.isEmpty()) {
            object2 = object2.iterator();
            while (object2.hasNext()) {
                if (!((ConnectionSpec)object2.next()).isTls()) continue;
                bl = false;
                break;
            }
        } else {
            bl = true;
        }
        if (!bl) {
            if (((OkHttpClient)object).sslSocketFactoryOrNull == null) throw new IllegalStateException("sslSocketFactory == null".toString());
            if (((OkHttpClient)object).certificateChainCleaner == null) throw new IllegalStateException("certificateChainCleaner == null".toString());
            if (((OkHttpClient)object).x509TrustManager == null) throw new IllegalStateException("x509TrustManager == null".toString());
            return;
        }
        if (!(((OkHttpClient)object).sslSocketFactoryOrNull == null)) throw new IllegalStateException("Check failed.".toString());
        if (!(((OkHttpClient)object).certificateChainCleaner == null)) throw new IllegalStateException("Check failed.".toString());
        if (!(((OkHttpClient)object).x509TrustManager == null)) throw new IllegalStateException("Check failed.".toString());
        if (!Intrinsics.areEqual(((OkHttpClient)object).certificatePinner, CertificatePinner.DEFAULT)) throw new IllegalStateException("Check failed.".toString());
    }

    public static final /* synthetic */ List access$getDEFAULT_PROTOCOLS$cp() {
        return DEFAULT_PROTOCOLS;
    }

    public static final /* synthetic */ List access$getDEFAULT_CONNECTION_SPECS$cp() {
        return DEFAULT_CONNECTION_SPECS;
    }

    public final Dispatcher dispatcher() {
        return this.dispatcher;
    }

    public final ConnectionPool connectionPool() {
        return this.connectionPool;
    }

    public final List interceptors() {
        return this.interceptors;
    }

    public final List networkInterceptors() {
        return this.networkInterceptors;
    }

    public final EventListener$Factory eventListenerFactory() {
        return this.eventListenerFactory;
    }

    public final boolean retryOnConnectionFailure() {
        return this.retryOnConnectionFailure;
    }

    public final Authenticator authenticator() {
        return this.authenticator;
    }

    public final boolean followRedirects() {
        return this.followRedirects;
    }

    public final boolean followSslRedirects() {
        return this.followSslRedirects;
    }

    public final CookieJar cookieJar() {
        return this.cookieJar;
    }

    public final Cache cache() {
        return null;
    }

    public final Dns dns() {
        return this.dns;
    }

    public final Proxy proxy() {
        return this.proxy;
    }

    public final ProxySelector proxySelector() {
        return this.proxySelector;
    }

    public final Authenticator proxyAuthenticator() {
        return this.proxyAuthenticator;
    }

    public final SocketFactory socketFactory() {
        return this.socketFactory;
    }

    public final SSLSocketFactory sslSocketFactory() {
        SSLSocketFactory sSLSocketFactory = ((OkHttpClient)((Object)sSLSocketFactory)).sslSocketFactoryOrNull;
        if (sSLSocketFactory != null) {
            return sSLSocketFactory;
        }
        throw new IllegalStateException("CLEARTEXT-only client");
    }

    public final List connectionSpecs() {
        return this.connectionSpecs;
    }

    public final List protocols() {
        return this.protocols;
    }

    public final HostnameVerifier hostnameVerifier() {
        return this.hostnameVerifier;
    }

    public final CertificatePinner certificatePinner() {
        return this.certificatePinner;
    }

    public final int callTimeoutMillis() {
        return this.callTimeoutMillis;
    }

    public final int connectTimeoutMillis() {
        return this.connectTimeoutMillis;
    }

    public final int readTimeoutMillis() {
        return this.readTimeoutMillis;
    }

    public final int writeTimeoutMillis() {
        return this.writeTimeoutMillis;
    }

    public final int pingIntervalMillis() {
        return this.pingIntervalMillis;
    }

    public final RouteDatabase getRouteDatabase() {
        return this.routeDatabase;
    }

    public Call newCall(Request request) {
        Intrinsics.checkNotNullParameter(request, "request");
        return new RealCall(this, request, false);
    }

    public Object clone() {
        return super.clone();
    }
}

