/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.connection;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketException;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Address;
import okhttp3.Call;
import okhttp3.EventListener;
import okhttp3.HttpUrl;
import okhttp3.Route;
import okhttp3.internal.Util;
import okhttp3.internal.connection.RouteDatabase;
import okhttp3.internal.connection.RouteSelector$Companion;
import okhttp3.internal.connection.RouteSelector$Selection;

public final class RouteSelector {
    public static final RouteSelector$Companion Companion = new RouteSelector$Companion(null);
    private final Address address;
    private final RouteDatabase routeDatabase;
    private final Call call;
    private final EventListener eventListener;
    private List proxies;
    private int nextProxyIndex;
    private List inetSocketAddresses;
    private final List postponedRoutes;

    public RouteSelector(Address address, RouteDatabase routeDatabase, Call call, EventListener eventListener) {
        RouteSelector routeSelector = httpUrl;
        Address address2 = address;
        RouteSelector routeSelector2 = httpUrl;
        Intrinsics.checkNotNullParameter(address, "address");
        Intrinsics.checkNotNullParameter(routeDatabase, "routeDatabase");
        Intrinsics.checkNotNullParameter(call, "call");
        Intrinsics.checkNotNullParameter(eventListener, "eventListener");
        ((RouteSelector)((Object)httpUrl)).address = address;
        ((RouteSelector)((Object)httpUrl)).routeDatabase = routeDatabase;
        ((RouteSelector)((Object)httpUrl)).call = call;
        routeSelector2.eventListener = eventListener;
        routeSelector2.proxies = CollectionsKt.emptyList();
        routeSelector2.inetSocketAddresses = CollectionsKt.emptyList();
        routeSelector2.postponedRoutes = new ArrayList();
        HttpUrl httpUrl = address2.url();
        routeSelector.resetNextProxy(httpUrl, address2.proxy());
    }

    private final void resetNextProxy(HttpUrl httpUrl, Proxy object) {
        this.eventListener.proxySelectStart(this.call, httpUrl);
        object = RouteSelector.resetNextProxy$selectProxies((Proxy)object, httpUrl, this);
        this.proxies = object;
        this.nextProxyIndex = 0;
        this.eventListener.proxySelectEnd(this.call, httpUrl, (List)object);
    }

    private final boolean hasNextProxy() {
        return this.nextProxyIndex < this.proxies.size();
    }

    private final Proxy nextProxy() {
        if (this.hasNextProxy()) {
            int n = this.nextProxyIndex;
            this.nextProxyIndex = n + 1;
            Proxy proxy = (Proxy)this.proxies.get(n);
            this.resetNextInetSocketAddress(proxy);
            return proxy;
        }
        throw new SocketException("No route to " + this.address.url().host() + "; exhausted proxy configurations: " + this.proxies);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void resetNextInetSocketAddress(Proxy object) {
        int n;
        Iterator iterator2;
        Object object2;
        ArrayList<InetSocketAddress> arrayList;
        ArrayList<InetSocketAddress> arrayList2 = arrayList;
        ((RouteSelector)((Object)iterator2)).inetSocketAddresses = new ArrayList<InetSocketAddress>();
        if (((Proxy)object).type() != Proxy.Type.DIRECT && ((Proxy)object).type() != Proxy.Type.SOCKS) {
            object2 = ((Proxy)object).address();
            if (!(object2 instanceof InetSocketAddress)) {
                iterator2 = Intrinsics.stringPlus("Proxy.address() is not an InetSocketAddress: ", object2.getClass());
                throw new IllegalArgumentException(iterator2.toString());
            }
            Object object3 = object2;
            object2 = Companion;
            Intrinsics.checkNotNullExpressionValue(object3, "proxyAddress");
            InetSocketAddress inetSocketAddress = (InetSocketAddress)object3;
            object2 = ((RouteSelector$Companion)object2).getSocketHost(inetSocketAddress);
            n = inetSocketAddress.getPort();
        } else {
            RouteSelector routeSelector = iterator2;
            object2 = routeSelector.address.url().host();
            n = routeSelector.address.url().port();
        }
        if (!(1 <= n && n < 65536)) throw new SocketException("No route to " + (String)object2 + ':' + n + "; port is out of range");
        if (((Proxy)object).type() == Proxy.Type.SOCKS) {
            arrayList2.add(InetSocketAddress.createUnresolved((String)object2, n));
            return;
        }
        Iterator iterator3 = iterator2;
        ((RouteSelector)((Object)iterator3)).eventListener.dnsStart(((RouteSelector)((Object)iterator2)).call, (String)object2);
        object = ((RouteSelector)((Object)iterator3)).address.dns().lookup((String)object2);
        if (object.isEmpty()) throw new UnknownHostException(((RouteSelector)((Object)iterator2)).address.dns() + " returned no addresses for " + (String)object2);
        ((RouteSelector)((Object)iterator2)).eventListener.dnsEnd(((RouteSelector)((Object)iterator2)).call, (String)object2, (List)object);
        iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            object = (InetAddress)iterator2.next();
            arrayList2.add(new InetSocketAddress((InetAddress)object, n));
        }
    }

    private static final List resetNextProxy$selectProxies(Proxy list, HttpUrl httpUrl, RouteSelector routeSelector) {
        if (list != null) {
            return CollectionsKt.listOf((Object)list);
        }
        list = httpUrl.uri();
        if (((URI)((Object)list)).getHost() == null) {
            return Util.immutableListOf(Proxy.NO_PROXY);
        }
        list = routeSelector.address.proxySelector().select((URI)((Object)list));
        boolean bl = list == null || list.isEmpty();
        if (bl) {
            return Util.immutableListOf(Proxy.NO_PROXY);
        }
        List<Proxy> list2 = list;
        Intrinsics.checkNotNullExpressionValue(list2, "proxiesOrNull");
        return Util.toImmutableList(list2);
    }

    public final boolean hasNext() {
        return this.hasNextProxy() || this.postponedRoutes.isEmpty() ^ true;
    }

    public final RouteSelector$Selection next() {
        if (this.hasNext()) {
            ArrayList<Route> arrayList;
            ArrayList<Route> arrayList2 = arrayList;
            arrayList = new ArrayList<Route>();
            while (this.hasNextProxy()) {
                RouteSelector routeSelector = this;
                Proxy proxy = routeSelector.nextProxy();
                for (InetSocketAddress inetSocketAddress : routeSelector.inetSocketAddresses) {
                    Route route;
                    Route route2 = route;
                    route = new Route(this.address, proxy, inetSocketAddress);
                    if (this.routeDatabase.shouldPostpone(route2)) {
                        this.postponedRoutes.add(route2);
                        continue;
                    }
                    arrayList2.add(route2);
                }
                if (!(arrayList2.isEmpty() ^ true)) continue;
            }
            if (arrayList2.isEmpty()) {
                CollectionsKt.addAll(arrayList2, this.postponedRoutes);
                this.postponedRoutes.clear();
            }
            return new RouteSelector$Selection(arrayList2);
        }
        throw new NoSuchElementException();
    }
}

