/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import java.util.Arrays;
import java.util.List;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.internal.http2.Header;
import okhttp3.internal.http2.Hpack;
import okhttp3.internal.http2.Huffman;
import okio.Buffer;
import okio.BufferedSink;
import okio.ByteString;

public final class Hpack$Writer {
    public int headerTableSizeSetting;
    private final boolean useCompression;
    private final Buffer out;
    private int smallestHeaderTableSizeSetting;
    private boolean emitDynamicTableSizeUpdate;
    public int maxDynamicTableByteCount;
    public Header[] dynamicTable;
    private int nextHeaderIndex;
    public int headerCount;
    public int dynamicTableByteCount;

    public Hpack$Writer(int n, boolean bl, Buffer buffer) {
        Header[] headerArray = headerArray2;
        Intrinsics.checkNotNullParameter(buffer, "out");
        headerArray2.headerTableSizeSetting = n;
        headerArray2.useCompression = bl;
        headerArray2.out = buffer;
        headerArray2.smallestHeaderTableSizeSetting = Integer.MAX_VALUE;
        headerArray.maxDynamicTableByteCount = n;
        Header[] headerArray2 = new Header[8];
        headerArray.dynamicTable = headerArray2;
        headerArray2.nextHeaderIndex = headerArray2.length - 1;
    }

    public /* synthetic */ Hpack$Writer(int n, boolean bl, Buffer buffer, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 4096;
        }
        if ((n2 & 2) != 0) {
            bl = true;
        }
        this(n, bl, buffer);
    }

    private final void clearDynamicTable() {
        Hpack$Writer hpack$Writer = this;
        ArraysKt.fill$default(hpack$Writer.dynamicTable, null, 0, 0, 6, null);
        hpack$Writer.nextHeaderIndex = hpack$Writer.dynamicTable.length - 1;
        hpack$Writer.headerCount = 0;
        hpack$Writer.dynamicTableByteCount = 0;
    }

    private final int evictToRecoverBytes(int n) {
        int n2 = 0;
        if (n > 0) {
            int n3;
            int n4;
            for (n4 = this.dynamicTable.length - 1; n4 >= (n3 = this.nextHeaderIndex) && n > 0; --n4) {
                Hpack$Writer hpack$Writer = this;
                Header header = this.dynamicTable[n4];
                Intrinsics.checkNotNull(header);
                n -= header.hpackSize;
                int n5 = hpack$Writer.dynamicTableByteCount;
                Header header2 = this.dynamicTable[n4];
                Intrinsics.checkNotNull(header2);
                hpack$Writer.dynamicTableByteCount = n5 - header2.hpackSize;
                hpack$Writer.headerCount += -1;
                ++n2;
            }
            Hpack$Writer hpack$Writer = this;
            int n6 = n3;
            n = n6 + 1;
            n4 = n6 + 1 + n2;
            n3 = this.headerCount;
            System.arraycopy(hpack$Writer.dynamicTable, n, hpack$Writer.dynamicTable, n4, n3);
            int n7 = this.nextHeaderIndex;
            int n8 = n7 + 1;
            Arrays.fill(hpack$Writer.dynamicTable, n8, n7 + 1 + n2, null);
            hpack$Writer.nextHeaderIndex += n2;
        }
        return n2;
    }

    private final void insertIntoDynamicTable(Header header) {
        int n = header.hpackSize;
        int n2 = this.maxDynamicTableByteCount;
        if (n > n2) {
            this.clearDynamicTable();
            return;
        }
        Hpack$Writer hpack$Writer = this;
        hpack$Writer.evictToRecoverBytes(hpack$Writer.dynamicTableByteCount + n - n2);
        Header[] headerArray = this.dynamicTable;
        if (hpack$Writer.headerCount + 1 > this.dynamicTable.length) {
            Header[] headerArray2 = headerArray;
            headerArray = new Header[headerArray.length * 2];
            int n3 = headerArray2.length;
            int n4 = headerArray.length;
            System.arraycopy(headerArray2, 0, headerArray, n3, n4);
            this.nextHeaderIndex = this.dynamicTable.length - 1;
            this.dynamicTable = headerArray;
        }
        Hpack$Writer hpack$Writer2 = this;
        int n5 = hpack$Writer2.nextHeaderIndex;
        hpack$Writer2.nextHeaderIndex = n5 + -1;
        hpack$Writer2.dynamicTable[n5] = header;
        ++hpack$Writer2.headerCount;
        hpack$Writer2.dynamicTableByteCount += n;
    }

    private final void adjustDynamicTableByteCount() {
        int n = this.maxDynamicTableByteCount;
        int n2 = this.dynamicTableByteCount;
        if (n < n2) {
            if (n == 0) {
                this.clearDynamicTable();
            } else {
                this.evictToRecoverBytes(n2 - n);
            }
        }
    }

    public final void writeHeaders(List list) {
        int n;
        Intrinsics.checkNotNullParameter(list, "headerBlock");
        if (this.emitDynamicTableSizeUpdate) {
            n = this.smallestHeaderTableSizeSetting;
            if (n < this.maxDynamicTableByteCount) {
                this.writeInt(n, 31, 32);
            }
            Hpack$Writer hpack$Writer = this;
            hpack$Writer.emitDynamicTableSizeUpdate = false;
            hpack$Writer.smallestHeaderTableSizeSetting = Integer.MAX_VALUE;
            hpack$Writer.writeInt(hpack$Writer.maxDynamicTableByteCount, 31, 32);
        }
        n = 0;
        int n2 = list.size();
        while (n < n2) {
            Header header = (Header)list.get(n++);
            ByteString byteString = header.name.toAsciiLowercase();
            ByteString byteString2 = header.value;
            int n3 = -1;
            int n4 = -1;
            Hpack hpack = Hpack.INSTANCE;
            Integer n5 = (Integer)hpack.getNAME_TO_FIRST_INDEX().get(byteString);
            if (n5 != null && 2 <= (n4 = n5 + 1) && n4 < 8) {
                if (Intrinsics.areEqual(hpack.getSTATIC_HEADER_TABLE()[n4 - 1].value, byteString2)) {
                    n3 = n4;
                } else if (Intrinsics.areEqual(hpack.getSTATIC_HEADER_TABLE()[n4].value, byteString2)) {
                    n3 = n4 + 1;
                }
            }
            if (n3 == -1) {
                Hpack$Writer hpack$Writer = this;
                int n6 = hpack$Writer.nextHeaderIndex + 1;
                int n7 = hpack$Writer.dynamicTable.length;
                while (n6 < n7) {
                    int n8 = n6 + 1;
                    Header header2 = this.dynamicTable[n6];
                    Intrinsics.checkNotNull(header2);
                    if (Intrinsics.areEqual(header2.name, byteString)) {
                        Header header3 = this.dynamicTable[n6];
                        Intrinsics.checkNotNull(header3);
                        if (Intrinsics.areEqual(header3.value, byteString2)) {
                            n3 = n6 - this.nextHeaderIndex + Hpack.INSTANCE.getSTATIC_HEADER_TABLE().length;
                            break;
                        }
                        if (n4 == -1) {
                            n4 = n6 - this.nextHeaderIndex + Hpack.INSTANCE.getSTATIC_HEADER_TABLE().length;
                            n6 = n8;
                            continue;
                        }
                    }
                    n6 = n8;
                }
            }
            if (n3 != -1) {
                this.writeInt(n3, 127, 128);
                continue;
            }
            if (n4 == -1) {
                this.out.writeByte(64);
                this.writeByteString(byteString);
                this.writeByteString(byteString2);
                this.insertIntoDynamicTable(header);
                continue;
            }
            if (byteString.startsWith(Header.PSEUDO_PREFIX) && !Intrinsics.areEqual(Header.TARGET_AUTHORITY, byteString)) {
                Hpack$Writer hpack$Writer = this;
                hpack$Writer.writeInt(n4, 15, 0);
                hpack$Writer.writeByteString(byteString2);
                continue;
            }
            Hpack$Writer hpack$Writer = this;
            hpack$Writer.writeInt(n4, 63, 64);
            hpack$Writer.writeByteString(byteString2);
            hpack$Writer.insertIntoDynamicTable(header);
        }
    }

    public final void writeInt(int n, int n2, int n3) {
        if (n < n2) {
            this.out.writeByte(n3 | n);
            return;
        }
        this.out.writeByte(n3 | n2);
        n -= n2;
        while (n >= 128) {
            int n4 = n;
            this.out.writeByte((n &= 0x7F) | 0x80);
            n = n4 >>> 7;
        }
        this.out.writeByte(n);
    }

    public final void writeByteString(ByteString byteString) {
        Huffman huffman;
        Intrinsics.checkNotNullParameter(byteString, "data");
        if (((Hpack$Writer)object).useCompression && (huffman = Huffman.INSTANCE).encodedLength(byteString) < byteString.size()) {
            Buffer buffer;
            Hpack$Writer hpack$Writer = object;
            Object object = buffer;
            ((Buffer)object)();
            huffman.encode(byteString, (BufferedSink)object);
            object = buffer.readByteString();
            hpack$Writer.writeInt(((ByteString)object).size(), 127, 128);
            hpack$Writer.out.write((ByteString)object);
        } else {
            Hpack$Writer hpack$Writer = object;
            hpack$Writer.writeInt(byteString.size(), 127, 0);
            hpack$Writer.out.write(byteString);
        }
    }

    public final void resizeHeaderTable(int n) {
        this.headerTableSizeSetting = n;
        int n2 = this.maxDynamicTableByteCount;
        if (n2 == (n = Math.min(n, 16384))) {
            return;
        }
        if (n < n2) {
            this.smallestHeaderTableSizeSetting = Math.min(this.smallestHeaderTableSizeSetting, n);
        }
        this.emitDynamicTableSizeUpdate = true;
        this.maxDynamicTableByteCount = n;
        this.adjustDynamicTableByteCount();
    }
}

