/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.platform;

import java.security.KeyStore;
import java.security.Provider;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.internal.platform.BouncyCastlePlatform$Companion;
import okhttp3.internal.platform.Platform;
import org.bouncycastle.jsse.BCSSLParameters;
import org.bouncycastle.jsse.BCSSLSocket;
import org.bouncycastle.jsse.provider.BouncyCastleJsseProvider;

public final class BouncyCastlePlatform
extends Platform {
    public static final BouncyCastlePlatform$Companion Companion;
    private static final boolean isSupported;
    private final Provider provider = (Provider)new BouncyCastleJsseProvider();

    private BouncyCastlePlatform() {
    }

    public static final /* synthetic */ boolean access$isSupported$cp() {
        return isSupported;
    }

    public /* synthetic */ BouncyCastlePlatform(DefaultConstructorMarker defaultConstructorMarker) {
        this();
    }

    static {
        boolean bl;
        BouncyCastlePlatform$Companion bouncyCastlePlatform$Companion;
        BouncyCastlePlatform$Companion bouncyCastlePlatform$Companion2 = bouncyCastlePlatform$Companion;
        Companion = new BouncyCastlePlatform$Companion(null);
        String string = "org.bouncycastle.jsse.provider.BouncyCastleJsseProvider";
        try {
            Class.forName(string, false, bouncyCastlePlatform$Companion2.getClass().getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            bl = false;
        }
        bl = true;
        isSupported = bl;
    }

    @Override
    public SSLContext newSSLContext() {
        SSLContext sSLContext = SSLContext.getInstance("TLS", this.provider);
        Intrinsics.checkNotNullExpressionValue(sSLContext, "getInstance(\"TLS\", provider)");
        return sSLContext;
    }

    @Override
    public X509TrustManager platformTrustManager() {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("PKIX", "BCJSSE");
        trustManagerFactory.init((KeyStore)null);
        Object object = trustManagerFactory.getTrustManagers();
        Intrinsics.checkNotNull(object);
        if (((TrustManager[])object).length == 1 && object[0] instanceof X509TrustManager) {
            if ((object = object[0]) != null) {
                return (X509TrustManager)object;
            }
            throw new NullPointerException("null cannot be cast to non-null type javax.net.ssl.X509TrustManager");
        }
        object = Arrays.toString((Object[])object);
        Intrinsics.checkNotNullExpressionValue(object, "toString(this)");
        object = Intrinsics.stringPlus("Unexpected default trust managers: ", object);
        throw new IllegalStateException(object.toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void configureTlsExtensions(SSLSocket sSLSocket, String stringArray, List list) {
        Intrinsics.checkNotNullParameter(sSLSocket, "sslSocket");
        Intrinsics.checkNotNullParameter(list, "protocols");
        if (sSLSocket instanceof BCSSLSocket) {
            BouncyCastlePlatform bouncyCastlePlatform = (BCSSLSocket)sSLSocket;
            sSLSocket = bouncyCastlePlatform.getParameters();
            stringArray = Platform.Companion.alpnProtocolNames(list).toArray(new String[0]);
            if (stringArray == null) throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            SSLSocket sSLSocket2 = sSLSocket;
            sSLSocket2.setApplicationProtocols(stringArray);
            bouncyCastlePlatform.setParameters((BCSSLParameters)sSLSocket2);
            return;
        } else {
            super.configureTlsExtensions(sSLSocket, (String)stringArray, list);
        }
    }

    @Override
    public String getSelectedProtocol(SSLSocket sSLSocket) {
        Object object;
        SSLSocket sSLSocket2 = sSLSocket;
        Intrinsics.checkNotNullParameter(sSLSocket2, "sslSocket");
        if (sSLSocket2 instanceof BCSSLSocket) {
            object = ((BCSSLSocket)sSLSocket).getApplicationProtocol();
            if (object == null ? true : Intrinsics.areEqual(object, "")) {
                object = null;
            }
        } else {
            object = super.getSelectedProtocol(sSLSocket);
        }
        return object;
    }
}

