/*
 * Decompiled with CFR 0.152.
 */
package okio.internal;

import java.util.ArrayList;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import okio.ByteString;
import okio.ByteString$Companion;
import okio.Path;

public abstract class _PathKt {
    private static final ByteString SLASH;
    private static final ByteString BACKSLASH;
    private static final ByteString ANY_SLASH;
    private static final ByteString DOT;
    private static final ByteString DOT_DOT;

    private static final int rootLength(Path path) {
        if (path.getBytes$okio().size() == 0) {
            return -1;
        }
        if (path.getBytes$okio().getByte(0) == (byte)47) {
            return 1;
        }
        int n = 92;
        if (path.getBytes$okio().getByte(0) == n) {
            if (path.getBytes$okio().size() > 2 && path.getBytes$okio().getByte(1) == n) {
                n = path.getBytes$okio().indexOf(BACKSLASH, 2);
                if (n == -1) {
                    n = path.getBytes$okio().size();
                }
                return n;
            }
            return 1;
        }
        if (path.getBytes$okio().size() > 2 && path.getBytes$okio().getByte(1) == (byte)58 && path.getBytes$okio().getByte(2) == n) {
            char c = (char)path.getBytes$okio().getByte(0);
            if (!('a' <= c && c < '{') && !('A' <= c && c < '[')) {
                return -1;
            }
            return 3;
        }
        return -1;
    }

    private static final int getIndexOfLastSlash(Path path) {
        int n = ByteString.lastIndexOf$default(path.getBytes$okio(), SLASH, 0, 2, null);
        if (n != -1) {
            return n;
        }
        return ByteString.lastIndexOf$default(path.getBytes$okio(), BACKSLASH, 0, 2, null);
    }

    private static final boolean lastSegmentIsDotDot(Path path) {
        if (path.getBytes$okio().endsWith(DOT_DOT)) {
            if (path.getBytes$okio().size() == 2) {
                return true;
            }
            if (path.getBytes$okio().rangeEquals(path.getBytes$okio().size() - 3, SLASH, 0, 1)) {
                return true;
            }
            if (path.getBytes$okio().rangeEquals(path.getBytes$okio().size() - 3, BACKSLASH, 0, 1)) {
                return true;
            }
        }
        return false;
    }

    public static final Path commonResolve(Path path, Path path2, boolean bl) {
        Path path3 = path2;
        Intrinsics.checkNotNullParameter(path, "<this>");
        Intrinsics.checkNotNullParameter(path3, "child");
        if (!path3.isAbsolute() && path2.volumeLetter() == null) {
            Buffer buffer;
            ByteString byteString = _PathKt.getSlash(path);
            if (byteString == null && (byteString = _PathKt.getSlash(path2)) == null) {
                byteString = _PathKt.toSlash(Path.DIRECTORY_SEPARATOR);
            }
            Buffer buffer2 = buffer;
            buffer2();
            buffer.write(path.getBytes$okio());
            if (buffer.size() > 0L) {
                buffer2.write(byteString);
            }
            buffer2.write(path2.getBytes$okio());
            return _PathKt.toPath(buffer2, bl);
        }
        return path2;
    }

    private static final ByteString getSlash(Path path) {
        ByteString byteString = SLASH;
        if (ByteString.indexOf$default(path.getBytes$okio(), byteString, 0, 2, null) == -1) {
            byteString = BACKSLASH;
            if (ByteString.indexOf$default(path.getBytes$okio(), byteString, 0, 2, null) == -1) {
                byteString = null;
            }
        }
        return byteString;
    }

    public static final Path commonToPath(String string, boolean bl) {
        Intrinsics.checkNotNullParameter(string, "<this>");
        return _PathKt.toPath(new Buffer().writeUtf8(string), bl);
    }

    public static final Path toPath(Buffer buffer, boolean n) {
        Buffer buffer2;
        Intrinsics.checkNotNullParameter(buffer, "<this>");
        ByteString byteString = null;
        Buffer buffer3 = buffer2;
        buffer2 = new Buffer();
        int n2 = 0;
        while (true) {
            ByteString byteString2;
            if (!buffer.rangeEquals(0L, byteString2 = SLASH) && !buffer.rangeEquals(0L, byteString2 = BACKSLASH)) {
                ArrayList<ByteString> arrayList;
                boolean bl = n2 >= 2 && Intrinsics.areEqual(byteString, byteString2);
                if (bl) {
                    Buffer buffer4 = buffer3;
                    Intrinsics.checkNotNull(byteString);
                    buffer4.write(byteString);
                    buffer4.write(byteString);
                } else if (n2 > 0) {
                    Intrinsics.checkNotNull(byteString);
                    buffer3.write(byteString);
                } else {
                    long l = buffer.indexOfElement(ANY_SLASH);
                    if (byteString == null) {
                        byteString = l == -1L ? _PathKt.toSlash(Path.DIRECTORY_SEPARATOR) : _PathKt.toSlash(buffer.getByte(l));
                    }
                    if (_PathKt.startsWithVolumeLetterAndColon(buffer, byteString)) {
                        if (l == 2L) {
                            buffer3.write(buffer, 3L);
                        } else {
                            buffer3.write(buffer, 2L);
                        }
                    }
                }
                n2 = buffer3.size() > 0L ? 1 : 0;
                ArrayList<ByteString> arrayList2 = arrayList;
                arrayList = new ArrayList<ByteString>();
                while (!buffer.exhausted()) {
                    ByteString byteString3;
                    long l = buffer.indexOfElement(ANY_SLASH);
                    if (l == -1L) {
                        byteString3 = buffer.readByteString();
                    } else {
                        Buffer buffer5 = buffer;
                        byteString3 = buffer5.readByteString(l);
                        buffer5.readByte();
                    }
                    ByteString byteString4 = DOT_DOT;
                    if (Intrinsics.areEqual(byteString3, byteString4)) {
                        if (n2 != 0 && arrayList2.isEmpty()) continue;
                        if (n != 0 && (n2 != 0 || !arrayList2.isEmpty() && !Intrinsics.areEqual(CollectionsKt.last(arrayList2), byteString4))) {
                            if (bl && arrayList2.size() == 1) continue;
                            CollectionsKt.removeLastOrNull(arrayList2);
                            continue;
                        }
                        arrayList2.add(byteString3);
                        continue;
                    }
                    if (Intrinsics.areEqual(byteString3, DOT) || Intrinsics.areEqual(byteString3, ByteString.EMPTY)) continue;
                    arrayList2.add(byteString3);
                }
                n = arrayList2.size();
                for (int i = 0; i < n; ++i) {
                    if (i > 0) {
                        buffer3.write(byteString);
                    }
                    buffer3.write((ByteString)arrayList2.get(i));
                }
                if (buffer3.size() == 0L) {
                    buffer3.write(DOT);
                }
                return new Path(buffer3.readByteString());
            }
            byte by = buffer.readByte();
            if (byteString == null) {
                byteString = _PathKt.toSlash(by);
            }
            ++n2;
        }
    }

    private static final ByteString toSlash(String string) {
        block4: {
            ByteString byteString;
            block3: {
                block2: {
                    if (!Intrinsics.areEqual(string, "/")) break block2;
                    byteString = SLASH;
                    break block3;
                }
                if (!Intrinsics.areEqual(string, "\\")) break block4;
                byteString = BACKSLASH;
            }
            return byteString;
        }
        throw new IllegalArgumentException("not a directory separator: " + string);
    }

    private static final ByteString toSlash(byte by) {
        block4: {
            ByteString byteString;
            block3: {
                block2: {
                    if (by != 47) break block2;
                    byteString = SLASH;
                    break block3;
                }
                if (by != 92) break block4;
                byteString = BACKSLASH;
            }
            return byteString;
        }
        throw new IllegalArgumentException("not a directory separator: " + by);
    }

    private static final boolean startsWithVolumeLetterAndColon(Buffer buffer, ByteString byteString) {
        if (!Intrinsics.areEqual(byteString, BACKSLASH)) {
            return false;
        }
        if (buffer.size() < 2L) {
            return false;
        }
        if (buffer.getByte(1L) != (byte)58) {
            return false;
        }
        char c = (char)buffer.getByte(0L);
        return 'a' <= c && c < '{' || 'A' <= c && c < '[';
    }

    public static final /* synthetic */ int access$rootLength(Path path) {
        return _PathKt.rootLength(path);
    }

    public static final /* synthetic */ ByteString access$getSLASH$p() {
        return SLASH;
    }

    public static final /* synthetic */ int access$getIndexOfLastSlash(Path path) {
        return _PathKt.getIndexOfLastSlash(path);
    }

    public static final /* synthetic */ ByteString access$getDOT$p() {
        return DOT;
    }

    public static final /* synthetic */ ByteString access$getBACKSLASH$p() {
        return BACKSLASH;
    }

    public static final /* synthetic */ boolean access$lastSegmentIsDotDot(Path path) {
        return _PathKt.lastSegmentIsDotDot(path);
    }

    public static final /* synthetic */ ByteString access$getDOT_DOT$p() {
        return DOT_DOT;
    }

    public static final /* synthetic */ ByteString access$getSlash(Path path) {
        return _PathKt.getSlash(path);
    }

    public static final /* synthetic */ ByteString access$toSlash(String string) {
        return _PathKt.toSlash(string);
    }

    static {
        ByteString$Companion byteString$Companion = ByteString.Companion;
        SLASH = byteString$Companion.encodeUtf8("/");
        BACKSLASH = byteString$Companion.encodeUtf8("\\");
        ANY_SLASH = byteString$Companion.encodeUtf8("/\\");
        DOT = byteString$Companion.encodeUtf8(".");
        DOT_DOT = byteString$Companion.encodeUtf8("..");
    }
}

